/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.linux_rec.layouts;

import java.util.Date;
import java.util.EnumSet;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.linux_rec.App;
import org.luwrain.app.linux_rec.Entry;
import org.luwrain.app.linux_rec.Strings;
import org.luwrain.controls.ListArea;
import org.luwrain.controls.NavigationArea;
import org.luwrain.core.Area;
import org.luwrain.core.Job;
import org.luwrain.core.Luwrain;
import org.luwrain.core.events.InputEvent;

public final class RecordingProgressLayout
extends LayoutBase {
    final App app;
    final Strings s;
    final NavigationArea area;
    private Job recJob = null;
    private String name = null;
    private Date started = null;

    public RecordingProgressLayout(final App app, LayoutBase.ActionHandler close, final ListArea<Entry> entriesArea) {
        super((AppBase)app);
        this.app = app;
        this.s = (Strings)app.getStrings();
        this.area = new NavigationArea(this.getControlContext()){

            public int getLineCount() {
                return 1;
            }

            public String getLine(int index) {
                return "";
            }

            public String getAreaName() {
                return RecordingProgressLayout.this.s.recordingProgressAreaName();
            }

            public boolean onInputEvent(InputEvent event) {
                if (event.isSpecial()) {
                    switch (event.getSpecial()) {
                        case ENTER: {
                            if (RecordingProgressLayout.this.recJob == null) {
                                RecordingProgressLayout.this.started = new Date();
                                RecordingProgressLayout.this.name = App.TIME_FORMAT.format(RecordingProgressLayout.this.started) + ".wav";
                                RecordingProgressLayout.this.recJob = RecordingProgressLayout.this.getLuwrain().newJob("sys", new String[]{"parecord", RecordingProgressLayout.this.name}, App.REC_DIR.toString(), EnumSet.noneOf(Luwrain.JobFlags.class), null);
                                app.message(RecordingProgressLayout.this.s.recStarted());
                            } else {
                                RecordingProgressLayout.this.recJob.stop();
                                RecordingProgressLayout.this.recJob = null;
                                Entry e = new Entry();
                                e.name = RecordingProgressLayout.this.name;
                                e.startedTimestamp = RecordingProgressLayout.this.started.getTime();
                                e.finishedTimestamp = new Date().getTime();
                                app.conf.entries.add(e);
                                entriesArea.refresh();
                                entriesArea.select((Object)e, false);
                                RecordingProgressLayout.this.getLuwrain().saveConf((Object)app.conf);
                                app.message(RecordingProgressLayout.this.s.recFinished());
                            }
                            return true;
                        }
                    }
                }
                return super.onInputEvent(event);
            }
        };
        this.setCloseHandler(close);
        this.setAreaLayout((Area)this.area, null);
    }
}

