/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.extensions.emacspeak;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;
import java.util.Set;
import javax.sound.sampled.AudioFormat;
import org.luwrain.core.Log;
import org.luwrain.core.NullCheck;
import org.luwrain.speech.Channel;
import org.luwrain.speech.Voice;

final class Emacspeak
implements Channel {
    private long nextId = 1L;
    private boolean def = false;
    private String name = "";
    private String command = "";
    private Process process;
    private OutputStream stream;
    private BufferedWriter writer;
    private int defPitch = 50;
    private int defRate = 50;

    Emacspeak(Map<String, String> params) throws Exception {
        NullCheck.notNull(params, (String)"params");
        if (!params.containsKey("exec") || params.get("exec").isEmpty()) {
            throw new Exception("No emacspeak server given (must be provided with 'exec' parameter)");
        }
        this.command = params.get("exec");
        if (!this.startProcess()) {
            throw new Exception("Unable to start emacspeak server with the command '" + this.command + "'");
        }
    }

    public String getVoiceName() {
        return "";
    }

    public void setVoice(String name) {
    }

    public Voice[] getVoices() {
        return new Voice[0];
    }

    public String getChannelName() {
        return "Emacspeak speech server (" + this.command + ")";
    }

    public long speak(String text, Channel.Listener listener, int relPitch, int relRate, boolean cancelPrevious) {
        if (cancelPrevious) {
            this.silence();
        }
        try {
            this.writer.write("q {" + text + "}\n");
            this.writer.write("d\n");
            this.writer.flush();
            this.stream.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return -1L;
    }

    public long speakLetter(char letter, Channel.Listener listener, int relPitch, int relRate, boolean cancelPrevious) {
        if (cancelPrevious) {
            this.silence();
        }
        try {
            this.writer.write("l {" + letter + "}\n");
            this.writer.flush();
            this.stream.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return -1L;
    }

    public Channel.Result synth(String text, OutputStream stream, AudioFormat format, Channel.SyncParams params, Set<Channel.Flags> flags) {
        return new Channel.Result(Channel.Result.Type.NOT_IMPLEMENTED);
    }

    public AudioFormat[] getSynthSupportedFormats() {
        return new AudioFormat[0];
    }

    public void silence() {
        try {
            this.writer.write("s\n");
            this.writer.flush();
            this.stream.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void close() {
    }

    private boolean startProcess() {
        try {
            this.process = new ProcessBuilder(this.command).start();
            this.stream = this.process.getOutputStream();
            this.process.getInputStream().close();
            this.writer = new BufferedWriter(new OutputStreamWriter(this.process.getOutputStream()));
            return true;
        }
        catch (IOException e) {
            Log.error((String)"linux", (String)("unable to start an emacspeak server " + this.command + ":" + e.getMessage()));
            e.printStackTrace();
            return false;
        }
    }
}

