/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.wiki;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.wiki.App;
import org.luwrain.app.wiki.Server;
import org.luwrain.app.wiki.ServersLayout;
import org.luwrain.app.wiki.Strings;
import org.luwrain.controls.ConsoleArea;
import org.luwrain.controls.ConsoleUtils;
import org.luwrain.core.Area;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.events.InputEvent;
import org.luwrain.io.api.mediawiki.Page;

final class MainLayout
extends LayoutBase
implements ConsoleArea.ClickHandler<Page> {
    private final App app;
    final ConsoleArea area;

    MainLayout(App app) {
        super((AppBase)app);
        this.app = app;
        this.area = new ConsoleArea(this.consoleParams(params -> {
            params.model = new ConsoleUtils.ListModel(app.pages);
            params.appearance = new Appearance();
            params.name = ((Strings)app.getStrings()).appName();
            params.clickHandler = this;
            params.inputPos = ConsoleArea.InputPos.TOP;
        }));
        LayoutBase.Actions actions = this.actions(new LayoutBase.ActionInfo[]{this.action("servers", ((Strings)app.getStrings()).actionServers(), new InputEvent(InputEvent.Special.F5), this::actServers)});
        this.area.setConsoleInputHandler((area, text) -> {
            NullCheck.notNull((Object)text, (String)"text");
            if (text.trim().isEmpty()) {
                return ConsoleArea.InputHandler.Result.REJECTED;
            }
            return app.search(text.trim()) ? ConsoleArea.InputHandler.Result.OK : ConsoleArea.InputHandler.Result.REJECTED;
        });
        this.area.setInputPrefix(((Strings)app.getStrings()).appName() + ">");
        this.setAreaLayout((Area)this.area, actions);
    }

    public boolean onConsoleClick(ConsoleArea area, int index, Page obj) {
        if (obj == null || !(obj instanceof Page)) {
            return false;
        }
        Page page = obj;
        Server serv = null;
        for (Server s : this.app.servers) {
            if (!page.baseUrl.equals(s.searchUrl)) continue;
            serv = s;
            break;
        }
        if (serv == null || serv.pagesUrl == null || serv.pagesUrl.trim().isEmpty()) {
            return false;
        }
        try {
            Object url = serv.pagesUrl;
            if (!((String)url).endsWith("/")) {
                url = (String)url + "/";
            }
            url = (String)url + URLEncoder.encode(page.title, "UTF-8").replaceAll("\\+", "%20");
            this.app.getLuwrain().launchApp("reader", new String[]{url});
        }
        catch (UnsupportedEncodingException e) {
            this.app.crash(e);
        }
        return true;
    }

    private boolean actServers() {
        ServersLayout serversLayout = new ServersLayout(this.app, () -> {
            this.app.setAreaLayout(this);
            this.app.getLuwrain().announceActiveArea();
            return true;
        });
        this.app.setAreaLayout(serversLayout);
        this.app.getLuwrain().announceActiveArea();
        return true;
    }

    final class Appearance
    implements ConsoleArea.Appearance<Page> {
        Appearance() {
        }

        public void announceItem(Page page) {
            NullCheck.notNull((Object)page, (String)"page");
            MainLayout.this.app.setEventResponse(DefaultEventResponse.listItem((String)MainLayout.this.app.getLuwrain().getSpeakableText(page.toString(), Luwrain.SpeakableTextType.NATURAL)));
        }

        public String getTextAppearance(Page page) {
            NullCheck.notNull((Object)page, (String)"page");
            return page.toString();
        }
    }
}

