/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.wiki;

import java.util.ArrayList;
import java.util.List;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.wiki.App;
import org.luwrain.app.wiki.Server;
import org.luwrain.app.wiki.Strings;
import org.luwrain.controls.FormArea;
import org.luwrain.controls.ListArea;
import org.luwrain.controls.ListUtils;
import org.luwrain.core.Area;
import org.luwrain.core.AreaLayout;
import org.luwrain.core.events.InputEvent;

final class ServersLayout
extends LayoutBase {
    private static final String NAME = "name";
    private static final String SEARCH__URL = "search-url";
    private static final String PAGES_URL = "pages-url";
    private final App app;
    final ListArea<Server> serversArea;
    final FormArea paramsArea;
    private final List<Server> servers = new ArrayList<Server>();

    ServersLayout(App app, LayoutBase.ActionHandler closing) {
        super((AppBase)app);
        this.app = app;
        this.servers.addAll(app.servers);
        this.serversArea = new ListArea(this.listParams(params -> {
            params.model = new ListUtils.ListModel(this.servers);
            params.name = ((Strings)app.getStrings()).serversAreaName();
        }));
        LayoutBase.Actions serversActions = this.actions(new LayoutBase.ActionInfo[]{this.action("new-server", ((Strings)app.getStrings()).actionNewServer(), new InputEvent(InputEvent.Special.INSERT), this::actNewServer)});
        this.paramsArea = new FormArea(this.getControlContext(), ((Strings)app.getStrings()).serverParamsAreaName());
        LayoutBase.Actions paramsActions = this.actions(new LayoutBase.ActionInfo[0]);
        this.setAreaLayout(AreaLayout.TOP_BOTTOM, (Area)this.serversArea, serversActions, (Area)this.paramsArea, paramsActions);
        this.setOkHandler(() -> {
            app.servers.clear();
            app.servers.addAll(this.servers);
            app.saveServers();
            return closing.onAction();
        });
        this.setCloseHandler(closing);
    }

    private boolean actNewServer() {
        String name = this.app.getConv().newServerName();
        if (name == null) {
            return true;
        }
        Server s = new Server();
        s.name = name.trim();
        s.searchUrl = "";
        s.pagesUrl = "";
        this.servers.add(s);
        this.serversArea.refresh();
        this.serversArea.select((Object)s, false);
        return true;
    }
}

