/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.extensions.rhvoice;

import com.github.olga_yakovleva.rhvoice.RHVoiceException;
import com.github.olga_yakovleva.rhvoice.SynthesisParameters;
import com.github.olga_yakovleva.rhvoice.TTSClient;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.core.NullCheck;
import org.luwrain.extensions.rhvoice.Channel;
import org.luwrain.speech.Channel;

class SpeakingThread
implements Runnable {
    private static final Logger log = LogManager.getLogger();
    private static final int AUDIO_LINE_BUFFER_SIZE = 3200;
    private static final float FRAME_RATE = 24000.0f;
    private final Channel.Listener listener;
    private final String text;
    private final Channel channel;
    private final SynthesisParameters params;
    private AudioFormat audioFormat = null;
    private SourceDataLine audioLine = null;
    private boolean interrupt = false;

    SpeakingThread(String text, Channel.Listener listener, Channel channel, SynthesisParameters params) {
        NullCheck.notNull((Object)text, (String)"text");
        NullCheck.notNull((Object)channel, (String)"channel");
        NullCheck.notNull((Object)params, (String)"params");
        this.listener = listener;
        this.text = text;
        this.channel = channel;
        this.params = params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Channel channel = this.channel;
        synchronized (channel) {
            if (this.interrupt) {
                return;
            }
            this.audioFormat = SpeakingThread.createAudioFormat();
            if (this.audioFormat == null) {
                return;
            }
            this.audioLine = SpeakingThread.createAudioLine(this.audioFormat);
            if (this.audioLine == null) {
                return;
            }
            try {
                try {
                    this.channel.getTtsEngine().speak(this.text, this.params, new TTSClient(){

                        public boolean setSampleRate(int sampleRate) {
                            return true;
                        }

                        public boolean playSpeech(short[] samples) {
                            try {
                                ByteBuffer buffer = ByteBuffer.allocate(samples.length * SpeakingThread.this.audioFormat.getFrameSize());
                                buffer.order(ByteOrder.LITTLE_ENDIAN);
                                buffer.asShortBuffer().put(samples);
                                byte[] bytes = buffer.array();
                                SpeakingThread.this.audioLine.write(bytes, 0, bytes.length);
                                if (SpeakingThread.this.interrupt) {
                                    return false;
                                }
                            }
                            catch (Exception e) {
                                log.error("Unable to speak");
                                return false;
                            }
                            return true;
                        }
                    });
                    if (!this.interrupt) {
                        this.audioLine.drain();
                    }
                    if (this.listener != null) {
                        this.listener.onFinished(-1L);
                    }
                }
                catch (RHVoiceException e) {
                    if (this.listener != null) {
                        this.listener.onFinished(-1L);
                    }
                    log.error("RHVoice error:", (Throwable)e);
                    SpeakingThread speakingThread = this;
                    synchronized (speakingThread) {
                        if (!this.interrupt) {
                            this.audioLine.stop();
                        }
                        this.audioLine.close();
                    }
                    return;
                }
            }
            finally {
                SpeakingThread speakingThread = this;
                synchronized (speakingThread) {
                    if (!this.interrupt) {
                        this.audioLine.stop();
                    }
                    this.audioLine.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void interrupt() {
        SpeakingThread speakingThread = this;
        synchronized (speakingThread) {
            this.interrupt = true;
            if (this.audioLine != null) {
                this.audioLine.stop();
            }
        }
    }

    static AudioFormat createAudioFormat() {
        return new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 24000.0f, 16, 1, 2, 24000.0f, false);
    }

    private static SourceDataLine createAudioLine(AudioFormat audioFormat) {
        NullCheck.notNull((Object)audioFormat, (String)"audioFormat");
        try {
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
            SourceDataLine audioLine = (SourceDataLine)AudioSystem.getLine(info);
            audioLine.open(audioFormat, 3200);
            audioLine.start();
            return audioLine;
        }
        catch (Exception e) {
            log.error("Unable to init audio line:", (Throwable)e);
            return null;
        }
    }
}

