/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.reader;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.UnknownHostException;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.reader.App;
import org.luwrain.app.reader.Strings;
import org.luwrain.controls.SimpleArea;
import org.luwrain.core.Area;
import org.luwrain.core.NullCheck;
import org.luwrain.util.Connections;

final class ErrorLayout
extends LayoutBase {
    private final App app;
    private final Throwable ex;
    private final SimpleArea errorArea;

    ErrorLayout(App app, Throwable ex, LayoutBase.ActionHandler closing) {
        super((AppBase)app);
        NullCheck.notNull((Object)ex, (String)"ex");
        this.app = app;
        this.ex = ex;
        this.errorArea = new SimpleArea(this.getControlContext(), ((Strings)app.getStrings()).errorAreaName());
        this.fillContent();
        if (closing != null) {
            this.setCloseHandler(closing);
        }
        this.setAreaLayout((Area)this.errorArea, this.actions(new LayoutBase.ActionInfo[0]));
    }

    private void fillContent() {
        if (this.ex instanceof Connections.InvalidHttpResponseCodeException) {
            Connections.InvalidHttpResponseCodeException e = (Connections.InvalidHttpResponseCodeException)this.ex;
            this.errorArea.update(lines -> {
                lines.add("");
                lines.add("\u041e\u0448\u0438\u0431\u043a\u0430 " + String.valueOf(e.getHttpCode()));
                lines.add("");
            });
            return;
        }
        if (this.ex instanceof UnknownHostException) {
            UnknownHostException e = (UnknownHostException)this.ex;
            this.errorArea.update(lines -> {
                lines.add("");
                lines.add("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0445\u043e\u0441\u0442: " + e.getMessage());
                lines.add("");
            });
            return;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.ex.printStackTrace(pw);
        pw.flush();
        sw.flush();
        String[] trace = sw.toString().split(System.lineSeparator(), -1);
        this.errorArea.update(lines -> {
            lines.add("");
            for (String s : trace) {
                lines.add(s);
            }
            lines.add("");
        });
    }
}

