/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.reader;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import org.luwrain.app.reader.Settings;
import org.luwrain.core.NullCheck;
import org.luwrain.io.api.books.v1.Book;

final class LocalRepoMetadata {
    private final Gson gson = new Gson();
    private final Settings sett;
    private List<Book> books = null;

    LocalRepoMetadata(Settings sett) {
        NullCheck.notNull((Object)sett, (String)"sett");
        this.sett = sett;
    }

    List<Book> getBooks() {
        if (this.books != null) {
            return this.books;
        }
        Data data = (Data)this.gson.fromJson(this.sett.getLocalRepoMetadata(""), Data.class);
        if (data == null) {
            data = new Data();
        }
        if (data.books == null) {
            data.books = new ArrayList<Book>();
        }
        this.books = new ArrayList<Book>(data.books);
        return this.books;
    }

    void save() {
        if (this.books == null) {
            return;
        }
        Data data = new Data();
        data.books = this.books;
        this.sett.setLocalRepoMetadata(this.gson.toJson((Object)data));
    }

    Book findBook(String id) {
        NullCheck.notEmpty((Object)id, (String)"id");
        for (Book b : this.getBooks()) {
            if (!b.getId().equals(id)) continue;
            return b;
        }
        return null;
    }

    void addBook(Book book) {
        NullCheck.notNull((Object)book, (String)"book");
        if (book.getId() == null || book.getId().isEmpty()) {
            throw new IllegalArgumentException("The book doesn't have an ID");
        }
        if (this.books == null) {
            this.getBooks();
        }
        for (Book b : this.books) {
            if (!b.getId().equals(book.getId())) continue;
            return;
        }
        this.books.add(book);
        this.save();
    }

    boolean removeBook(Book book) {
        NullCheck.notNull((Object)book, (String)"book");
        if (book.getId() == null || book.getId().isEmpty()) {
            throw new IllegalArgumentException("The book doesn't have an ID");
        }
        if (this.books == null) {
            this.getBooks();
        }
        for (int i = 0; i < this.books.size(); ++i) {
            if (!this.books.get(i).equals((Object)book)) continue;
            this.books.remove(i);
            this.save();
            return true;
        }
        return false;
    }

    private static final class Data {
        @SerializedName(value="books")
        List<Book> books = null;

        private Data() {
        }
    }
}

