/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.reader;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.FutureTask;
import java.util.function.Supplier;
import org.luwrain.app.reader.App;
import org.luwrain.app.reader.Attributes;
import org.luwrain.controls.EditableListArea;
import org.luwrain.core.NullCheck;
import org.luwrain.io.api.books.v1.Note;

final class Notes
implements EditableListArea.Model {
    private final App app;
    private final Attributes attrs;
    private final List<Note> notes;
    private FutureTask task = null;

    Notes(App app, String bookId) {
        NullCheck.notNull((Object)((Object)app), (String)"app");
        NullCheck.notEmpty((Object)bookId, (String)"bookId");
        this.app = app;
        this.attrs = app.getAttributes();
        this.notes = this.attrs.getBookNotes(bookId);
    }

    boolean setBookmark(int pos) {
        if (pos < 0) {
            throw new IllegalArgumentException("pos can't be negative");
        }
        Note note = new Note();
        note.setType("BOOKMARK");
        note.setPos(String.valueOf(pos));
        for (int i = 0; i < this.notes.size(); ++i) {
            if (this.notes.get(i).getType() == null || !this.notes.get(i).getType().equals("BOOKMARK")) continue;
            this.notes.set(i, note);
            this.attrs.save();
            return true;
        }
        this.notes.add(note);
        this.attrs.save();
        return true;
    }

    Note getBookmark() {
        for (Note n : this.notes) {
            if (n.getType() == null || !n.getType().equals("BOOKMARK")) continue;
            return n;
        }
        return null;
    }

    boolean addNote(int pos, String text) {
        NullCheck.notNull((Object)text, (String)"text");
        if (pos < 0) {
            throw new IllegalArgumentException("pos can't be negative");
        }
        Note note = new Note();
        note.setType("NOTE");
        note.setPos(String.valueOf(pos));
        this.notes.add(0, note);
        this.attrs.save();
        return true;
    }

    boolean addNotes(int pos, List<Note> notes) {
        return !this.isBusy();
    }

    boolean removeNotes(int posFrom, int posTo) {
        return !this.isBusy();
    }

    public int getItemCount() {
        return this.notes.size();
    }

    public Note getItem(int index) {
        return this.notes.get(index);
    }

    public boolean addToModel(int pos, Supplier supplier) {
        NullCheck.notNull((Object)supplier, (String)"supplier");
        if (pos < 0 || pos > this.getItemCount()) {
            throw new IllegalArgumentException("pos (" + String.valueOf(pos) + ") must be non-negative and not greater than " + String.valueOf(this.getItemCount()));
        }
        Object supplied = supplier.get();
        if (supplied == null) {
            return false;
        }
        Object[] newNotes = supplied instanceof Object[] ? (Object[])supplied : new Object[]{supplied};
        for (Object o : newNotes) {
            if (o instanceof Note) continue;
            return false;
        }
        return this.addNotes(pos, Arrays.asList((Note[])Arrays.copyOf(newNotes, newNotes.length, Note[].class)));
    }

    public boolean removeFromModel(int posFrom, int posTo) {
        if (posFrom < 0 || posFrom >= this.getItemCount()) {
            throw new IllegalArgumentException("pos (" + String.valueOf(posFrom) + ") must be non-negative and less than " + String.valueOf(this.getItemCount()));
        }
        if (posTo < 0 || posTo >= this.getItemCount()) {
            throw new IllegalArgumentException("pos (" + String.valueOf(posTo) + ") must be non-negative and less or equal than " + String.valueOf(this.getItemCount()));
        }
        return this.removeNotes(posFrom, posTo);
    }

    public void refresh() {
    }

    private boolean isBusy() {
        return this.task != null && !this.task.isDone();
    }
}

