/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.reader;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.luwrain.app.reader.Settings;
import org.luwrain.core.Log;
import org.luwrain.core.NullCheck;
import org.luwrain.util.FileUtils;
import org.luwrain.util.LineIterator;

final class StandaloneSettings
implements Settings {
    private static final String LOG_COMPONENT = "reader";
    private static final String REPO_FILE = "repo.json";
    private static final String ATTRS_FILE = "attrs.json";
    private static final String UTF_8 = "UTF-8";
    private final File dir;

    StandaloneSettings(File dir) {
        NullCheck.notNull((Object)dir, (String)"dir");
        this.dir = dir;
    }

    @Override
    public String getLocalRepoMetadata(String defValue) {
        File repoFile = new File(this.dir, REPO_FILE);
        try {
            Files.createDirectories(this.dir.toPath(), new FileAttribute[0]);
            return LineIterator.join((File)repoFile, (String)UTF_8, (String)System.lineSeparator());
        }
        catch (IOException e) {
            Log.error((String)LOG_COMPONENT, (String)("unable to read the local repo file " + repoFile.getAbsolutePath() + ": " + e.getClass().getName() + ": " + e.getMessage()));
            e.printStackTrace();
            return defValue;
        }
    }

    @Override
    public void setLocalRepoMetadata(String value) {
        File repoFile = new File(this.dir, REPO_FILE);
        try {
            Files.createDirectories(this.dir.toPath(), new FileAttribute[0]);
            FileUtils.writeTextFile((File)repoFile, (String)value, (String)UTF_8);
        }
        catch (IOException e) {
            Log.error((String)LOG_COMPONENT, (String)("unable to write the local repo file  " + repoFile.getAbsolutePath() + ": " + e.getClass().getName() + ": " + e.getMessage()));
            e.printStackTrace();
        }
    }

    @Override
    public String getAttributes(String defValue) {
        File attrsFile = new File(this.dir, ATTRS_FILE);
        try {
            Files.createDirectories(this.dir.toPath(), new FileAttribute[0]);
            return LineIterator.join((File)attrsFile, (String)UTF_8, (String)System.lineSeparator());
        }
        catch (IOException e) {
            Log.error((String)LOG_COMPONENT, (String)("unable to read the local attributes file " + attrsFile.getAbsolutePath() + ": " + e.getClass().getName() + ": " + e.getMessage()));
            e.printStackTrace();
            return defValue;
        }
    }

    @Override
    public void setAttributes(String value) {
        NullCheck.notNull((Object)value, (String)"value");
        File attrsFile = new File(this.dir, ATTRS_FILE);
        try {
            Files.createDirectories(this.dir.toPath(), new FileAttribute[0]);
            FileUtils.writeTextFile((File)attrsFile, (String)value, (String)UTF_8);
        }
        catch (IOException e) {
            Log.error((String)LOG_COMPONENT, (String)("unable to write the local attributes file  " + attrsFile.getAbsolutePath() + ": " + e.getClass().getName() + ": " + e.getMessage()));
            e.printStackTrace();
        }
    }
}

