/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.reader.books;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.luwrain.app.reader.books.AudioFragment;
import org.luwrain.app.reader.books.Book;
import org.luwrain.app.reader.books.SectionsVisitor;
import org.luwrain.app.reader.books.Smil;
import org.luwrain.app.reader.books.UrlLoader;
import org.luwrain.core.Log;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.reader.Document;
import org.luwrain.reader.Visitor;

final class Daisy2
implements Book {
    private static final String LOG_COMPONENT = "daisy";
    protected final Luwrain luwrain;
    protected final Map<URL, Document> docs = new HashMap<URL, Document>();
    protected final Map<URL, Smil.Entry> smils = new HashMap<URL, Smil.Entry>();
    protected Document nccDoc = null;
    protected URL nccDocUrl = null;
    protected Book.Section[] bookSections = new Book.Section[0];

    Daisy2(Luwrain luwrain) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        this.luwrain = luwrain;
    }

    @Override
    public String getBookId() {
        return "FIXME";
    }

    @Override
    public Set<Book.Flags> getBookFlags() {
        return EnumSet.of(Book.Flags.OPEN_IN_SECTION_TREE);
    }

    @Override
    public Document getDefaultDocument() {
        return this.nccDoc;
    }

    @Override
    public Document getDocument(String href) {
        Smil.Entry entry;
        Smil.Entry requested;
        URL noRefUrl;
        URL url;
        NullCheck.notNull((Object)href, (String)"href");
        try {
            url = new URL(href);
            noRefUrl = new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getFile());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
        if (this.smils.containsKey(noRefUrl) && (requested = (entry = this.smils.get(noRefUrl)).findById(url.getRef())) != null) {
            Log.debug((String)"doctree", (String)("requested entry type is " + String.valueOf((Object)requested.type)));
            if (requested.type == Smil.Entry.Type.PAR || requested.type == Smil.Entry.Type.SEQ) {
                LinkedList<String> links = new LinkedList<String>();
                Daisy2.collectTextStartingAtEntry(requested, links);
                Log.debug((String)"doctree", (String)("collected " + links.size() + " entries"));
                if (!links.isEmpty()) {
                    String link = links.getFirst();
                    Log.debug((String)"doctree", (String)("using link " + link));
                    return this.getDocument(link);
                }
                Log.debug((String)"doctree", (String)"nothing found in SMILs");
                return null;
            }
            if (requested.type == Smil.Entry.Type.TEXT) {
                return this.getDocument(requested.src());
            }
            Log.warning((String)"doctree-daisy", (String)("URL " + href + " points to a SMIL entry, but its type is " + String.valueOf((Object)requested.type)));
            return null;
        }
        if (this.docs.containsKey(noRefUrl)) {
            Document res = this.docs.get(noRefUrl);
            if (res != null && url.getRef() != null) {
                res.setProperty("startingref", url.getRef());
            } else {
                res.setProperty("startingref", "");
            }
            return res;
        }
        if (this.nccDoc.getUrl().equals(url)) {
            if (url.getRef() != null) {
                this.nccDoc.setProperty("startingref", url.getRef());
            } else {
                this.nccDoc.setProperty("startingref", "");
            }
            return this.nccDoc;
        }
        Log.warning((String)"doctree", (String)("unable to find a document in Daisy2 book for URL:" + url.toString()));
        return null;
    }

    @Override
    public AudioFragment findAudioForId(String id) {
        NullCheck.notNull((Object)id, (String)"id");
        Log.debug((String)"doctree-daisy", (String)("searching audio for " + id));
        for (Map.Entry<URL, Smil.Entry> e : this.smils.entrySet()) {
            Smil.Entry entry = Daisy2.findSmilEntryWithText(e.getValue(), id);
            if (entry == null) continue;
            LinkedList<AudioFragment> infos = new LinkedList<AudioFragment>();
            Daisy2.collectAudioStartingAtEntry(entry, infos);
            if (infos.size() <= 0) continue;
            return infos.getFirst();
        }
        return null;
    }

    @Override
    public String findTextForAudio(String audioFileUrl, long msec) {
        NullCheck.notNull((Object)audioFileUrl, (String)"audioFileUrl");
        Log.debug((String)"doctree-daisy", (String)("text for " + audioFileUrl + " at " + msec));
        for (Map.Entry<URL, Smil.Entry> e : this.smils.entrySet()) {
            Smil.Entry entry = this.findSmilEntryWithAudio(e.getValue(), audioFileUrl, msec);
            if (entry == null) continue;
            LinkedList<String> links = new LinkedList<String>();
            Daisy2.collectTextStartingAtEntry(entry, links);
            if (links.size() <= 0) continue;
            return links.getFirst();
        }
        return null;
    }

    void init(Document nccDoc) {
        NullCheck.notNull((Object)nccDoc, (String)"nccDoc");
        nccDoc.setProperty("daisy.localpath", nccDoc.getUrl().getFile());
        String[] allHrefs = nccDoc.getHrefs();
        LinkedList<String> textSrcs = new LinkedList<String>();
        for (String h : allHrefs) {
            try {
                URL url = new URL(nccDoc.getUrl(), h);
                url = new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getFile());
                if (url.getFile().toLowerCase().endsWith(".smil")) {
                    this.loadSmil(url, textSrcs);
                    continue;
                }
                textSrcs.add(h);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        Log.debug((String)LOG_COMPONENT, (String)(this.smils.size() + " SMIL(s) loaded"));
        for (String s : textSrcs) {
            try {
                URL url = new URL(nccDoc.getUrl(), s);
                url = new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getFile());
                this.loadDoc(s, url);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        Log.debug((String)LOG_COMPONENT, (String)(this.docs.size() + " documents loaded"));
        this.nccDoc = nccDoc;
        this.nccDocUrl = this.nccDoc.getUrl();
        SectionsVisitor visitor = new SectionsVisitor();
        Visitor.walk(nccDoc.getRoot(), visitor);
        Book.Section[] sections = visitor.getBookSections();
        for (int i = 0; i < sections.length; ++i) {
            try {
                String text;
                URL url = new URL(sections[i].href);
                URL fileUrl = new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getFile());
                if (!fileUrl.getFile().toLowerCase().endsWith(".smil") || url.getRef().isEmpty() || (text = this.smilEntryToText(fileUrl, url.getRef())) == null) continue;
                sections[i] = new Book.Section(sections[i].level, sections[i].title, text);
                continue;
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        this.bookSections = sections;
    }

    @Override
    public Book.Section[] getBookSections() {
        return this.bookSections;
    }

    private void loadSmil(URL url, List<String> textSrcs) {
        NullCheck.notNull((Object)url, (String)"url");
        if (this.smils.containsKey(url)) {
            return;
        }
        Smil.Entry smil = Smil.fromUrl(url);
        if (smil == null) {
            throw new RuntimeException("Unable to load SMIL from " + url.toString());
        }
        this.smils.put(url, smil);
        smil.saveTextSrc(textSrcs);
        try {
            smil.allSrcToUrls(url);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    private void loadDoc(String localPath, URL url) {
        UrlLoader.Result res;
        if (this.docs.containsKey(url)) {
            return;
        }
        try {
            res = this.loadDoc(url);
        }
        catch (Exception e) {
            Log.error((String)"doctree-daisy", (String)("unable to read a document from URL " + url.toString()));
            e.printStackTrace();
            return;
        }
        if (res.book != null) {
            Log.debug((String)"doctree-daisy", (String)("the URL " + String.valueOf(url) + "references a book, not including to current one"));
            return;
        }
        res.doc.setProperty("daisy.localpath", localPath);
        this.docs.put(url, res.doc);
    }

    private static Smil.Entry findSmilEntryWithText(Smil.Entry entry, String src) {
        NullCheck.notNull((Object)entry, (String)"entry");
        NullCheck.notNull((Object)src, (String)"src");
        switch (entry.type) {
            case TEXT: {
                return entry.src() != null && entry.src().equals(src) ? entry : null;
            }
            case AUDIO: {
                return null;
            }
            case FILE: 
            case SEQ: {
                for (int i = 0; i < entry.entries.length; ++i) {
                    Smil.Entry res = Daisy2.findSmilEntryWithText(entry.entries[i], src);
                    if (res == null) continue;
                    if (res != entry.entries[i]) {
                        return res;
                    }
                    if (i == 0) {
                        return entry;
                    }
                    return entry.entries[i];
                }
                return null;
            }
            case PAR: {
                for (Smil.Entry e : entry.entries) {
                    Smil.Entry res = Daisy2.findSmilEntryWithText(e, src);
                    if (res == null) continue;
                    return entry;
                }
                return null;
            }
        }
        Log.warning((String)"doctree-daisy", (String)("unknown SMIL entry type:" + String.valueOf((Object)entry.type)));
        return null;
    }

    private Smil.Entry findSmilEntryWithAudio(Smil.Entry entry, String audioFileUrl, long msec) {
        NullCheck.notNull((Object)entry, (String)"entry");
        NullCheck.notNull((Object)audioFileUrl, (String)"audioFileUrl");
        switch (entry.type) {
            case AUDIO: {
                return entry.getAudioFragment().covers(audioFileUrl, msec, this.nccDocUrl) ? entry : null;
            }
            case TEXT: {
                return null;
            }
            case FILE: 
            case SEQ: {
                for (int i = 0; i < entry.entries.length; ++i) {
                    Smil.Entry res = this.findSmilEntryWithAudio(entry.entries[i], audioFileUrl, msec);
                    if (res == null) continue;
                    if (res != entry.entries[i]) {
                        return res;
                    }
                    if (i == 0) {
                        return entry;
                    }
                    return entry.entries[i];
                }
                return null;
            }
            case PAR: {
                for (Smil.Entry e : entry.entries) {
                    Smil.Entry res = this.findSmilEntryWithAudio(e, audioFileUrl, msec);
                    if (res == null) continue;
                    return entry;
                }
                return null;
            }
        }
        Log.warning((String)"doctree-daisy", (String)("unknown SMIL entry type:" + String.valueOf((Object)entry.type)));
        return null;
    }

    private static void collectAudioStartingAtEntry(Smil.Entry entry, LinkedList<AudioFragment> audioInfos) {
        NullCheck.notNull((Object)entry, (String)"entry");
        NullCheck.notNull(audioInfos, (String)"audioInfos");
        switch (entry.type) {
            case AUDIO: {
                audioInfos.add(entry.getAudioFragment());
                return;
            }
            case TEXT: {
                return;
            }
            case PAR: {
                for (Smil.Entry e : entry.entries) {
                    Daisy2.collectAudioStartingAtEntry(e, audioInfos);
                }
                return;
            }
            case FILE: 
            case SEQ: {
                if (entry.entries.length >= 1) {
                    Daisy2.collectAudioStartingAtEntry(entry.entries[0], audioInfos);
                }
                return;
            }
        }
        Log.warning((String)"doctree-daisy", (String)("unknown SMIL entry type:" + String.valueOf((Object)entry.type)));
    }

    private static void collectTextStartingAtEntry(Smil.Entry entry, LinkedList<String> links) {
        NullCheck.notNull((Object)entry, (String)"entry");
        NullCheck.notNull(links, (String)"links");
        switch (entry.type) {
            case AUDIO: {
                return;
            }
            case TEXT: {
                links.add(entry.src());
                return;
            }
            case PAR: {
                for (Smil.Entry e : entry.entries) {
                    Daisy2.collectTextStartingAtEntry(e, links);
                }
                return;
            }
            case FILE: 
            case SEQ: {
                if (entry.entries.length >= 1) {
                    Daisy2.collectTextStartingAtEntry(entry.entries[0], links);
                }
                return;
            }
        }
        Log.warning((String)"doctree-daisy", (String)("unknown SMIL entry type:" + String.valueOf((Object)entry.type)));
    }

    private String smilEntryToText(URL url, String id) {
        if (!this.smils.containsKey(url)) {
            return null;
        }
        Smil.Entry entry = this.smils.get(url).findById(id);
        if (entry == null) {
            return null;
        }
        LinkedList<String> links = new LinkedList<String>();
        Daisy2.collectTextStartingAtEntry(entry, links);
        return !links.isEmpty() ? links.getFirst() : null;
    }

    private UrlLoader.Result loadDoc(URL url) throws MalformedURLException, IOException {
        UrlLoader loader = new UrlLoader(this.luwrain, url);
        return loader.load();
    }
}

