/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls.reader.view;

import java.util.ArrayList;
import org.luwrain.controls.reader.view.RowPart;
import org.luwrain.core.NullCheck;
import org.luwrain.reader.Run;

public final class Row {
    int x = 0;
    int y = 0;
    private final RowPart[] parts;
    private final int partsFrom;
    private final int partsTo;

    Row() {
        this.parts = null;
        this.partsFrom = -1;
        this.partsTo = -1;
    }

    Row(RowPart[] parts, int partsFrom, int partsTo) {
        NullCheck.notNull((Object)parts, (String)"parts");
        if (partsFrom < 0) {
            throw new IllegalArgumentException("partsFrom (" + partsFrom + ") may not be negative");
        }
        if (partsTo < 0) {
            throw new IllegalArgumentException("partsTo (" + partsTo + ") may not be negative");
        }
        if (partsFrom >= partsTo) {
            throw new IllegalArgumentException("partsFrom (" + partsFrom + ") must be less than partsTo (" + partsTo + ")");
        }
        this.parts = parts;
        this.partsFrom = partsFrom;
        this.partsTo = partsTo;
    }

    public String getText() {
        StringBuilder b = new StringBuilder();
        for (int i = this.partsFrom; i < this.partsTo; ++i) {
            b.append(this.parts[i].getText());
        }
        return b.toString();
    }

    Run getRunUnderPos(int pos) {
        if (pos < 0) {
            throw new IllegalArgumentException("pos may not be negative");
        }
        int index = this.getPartIndexUnderPos(pos);
        if (index < 0) {
            return null;
        }
        return this.parts[index].run;
    }

    public Run[] getRuns() {
        ArrayList<Run> res = new ArrayList<Run>();
        for (int i = this.partsFrom; i < this.partsTo; ++i) {
            Run run = this.parts[i].run;
            int k = 0;
            for (k = 0; k < res.size() && res.get(k) != run; ++k) {
            }
            if (k < res.size()) continue;
            res.add(run);
        }
        return res.toArray(new Run[res.size()]);
    }

    public int runBeginsAt(Run run) {
        NullCheck.notNull((Object)run, (String)"run");
        int offset = 0;
        for (int i = this.partsFrom; i < this.partsTo; ++i) {
            String text = this.parts[i].getText();
            if (text == null || text.isEmpty()) continue;
            if (this.parts[i].run == run) {
                return offset;
            }
            offset += text.length();
        }
        return offset;
    }

    public int getRelNum() {
        return this.getFirstPart().relRowNum;
    }

    public Run getFirstRun() {
        return this.getFirstPart().run;
    }

    public int getRowX() {
        return this.x;
    }

    public int getRowY() {
        return this.y;
    }

    private RowPart getFirstPart() {
        return this.parts[this.partsFrom];
    }

    private int getPartIndexUnderPos(int pos) {
        if (pos < 0) {
            throw new IllegalArgumentException("pos may not be negative");
        }
        int offset = 0;
        for (int i = this.partsFrom; i < this.partsTo; ++i) {
            String text = this.parts[i].getText();
            if (text == null || text.isEmpty()) continue;
            if (pos >= offset && pos < offset + text.length()) {
                return i;
            }
            offset += text.length();
        }
        return -1;
    }
}

