/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.reader.view;

import java.util.LinkedList;
import org.luwrain.core.NullCheck;
import org.luwrain.reader.view.RowPart;

class TextExtractor {
    protected static final String LOG_COMPONENT = "document";
    final LinkedList<String> lines = new LinkedList();

    TextExtractor() {
    }

    protected void onParagraphLines(RowPart[] rowParts) {
        NullCheck.notNullItems((Object[])rowParts, (String)"rowParts");
        if (rowParts.length == 0) {
            return;
        }
        int lineNum = rowParts[0].relRowNum;
        int i = 0;
        while (i < rowParts.length) {
            StringBuilder b = new StringBuilder();
            while (i < rowParts.length && rowParts[i].relRowNum == lineNum) {
                b.append(rowParts[i].getText());
                ++i;
            }
            String s = new String(b);
            if (!s.isEmpty()) {
                this.lines.add(s);
            }
            if (i >= rowParts.length) continue;
            lineNum = rowParts[i].relRowNum;
        }
    }

    protected void addEmptyLine() {
        if (this.lines.isEmpty()) {
            return;
        }
        if (this.lines.getLast().isEmpty()) {
            return;
        }
        this.lines.add("");
    }

    public String[] getLines() {
        return this.lines.toArray(new String[this.lines.size()]);
    }
}

